const https = require('https');
const fs = require('fs');
const path = require('path');

// Using placeholder.com with different sizes and colors for variety
const imageOptions = {
    // APPAREL
    'logo-tee': [
        'https://via.placeholder.com/800x800/000000/FFFFFF?text=Black+T-Shirt+1', // Black t-shirt option 1
        'https://via.placeholder.com/800x800/333333/FFFFFF?text=Black+T-Shirt+2', // Black t-shirt option 2
        'https://via.placeholder.com/800x800/666666/FFFFFF?text=Black+T-Shirt+3', // Black t-shirt option 3
        'https://via.placeholder.com/800x800/999999/FFFFFF?text=Black+T-Shirt+4', // Black t-shirt option 4
    ],

    'hoodie-black': [
        'https://via.placeholder.com/800x800/000000/FFFFFF?text=Black+Hoodie+1', // Black hoodie option 1
        'https://via.placeholder.com/800x800/1a1a1a/FFFFFF?text=Black+Hoodie+2', // Black hoodie option 2
        'https://via.placeholder.com/800x800/333333/FFFFFF?text=Black+Hoodie+3', // Black hoodie option 3
        'https://via.placeholder.com/800x800/4d4d4d/FFFFFF?text=Black+Hoodie+4', // Black hoodie option 4
    ],

    'snapback': [
        'https://via.placeholder.com/800x800/000000/FFFFFF?text=Snapback+Cap+1', // Snapback option 1
        'https://via.placeholder.com/800x800/2c2c2c/FFFFFF?text=Snapback+Cap+2', // Snapback option 2
        'https://via.placeholder.com/800x800/404040/FFFFFF?text=Snapback+Cap+3', // Snapback option 3
        'https://via.placeholder.com/800x800/525252/FFFFFF?text=Snapback+Cap+4', // Snapback option 4
    ],

    'work-shirt': [
        'https://via.placeholder.com/800x800/2c3e50/FFFFFF?text=Work+Shirt+1', // Work shirt option 1
        'https://via.placeholder.com/800x800/34495e/FFFFFF?text=Work+Shirt+2', // Work shirt option 2
        'https://via.placeholder.com/800x800/7f8c8d/FFFFFF?text=Work+Shirt+3', // Work shirt option 3
        'https://via.placeholder.com/800x800/95a5a6/FFFFFF?text=Work+Shirt+4', // Work shirt option 4
    ],

    'beanie': [
        'https://via.placeholder.com/800x800/000000/FFFFFF?text=Black+Beanie+1', // Beanie option 1
        'https://via.placeholder.com/800x800/2c2c2c/FFFFFF?text=Black+Beanie+2', // Beanie option 2
        'https://via.placeholder.com/800x800/404040/FFFFFF?text=Black+Beanie+3', // Beanie option 3
        'https://via.placeholder.com/800x800/525252/FFFFFF?text=Black+Beanie+4', // Beanie option 4
    ],

    // DETAILING PRODUCTS
    'care-kit': [
        'https://via.placeholder.com/800x800/3498db/FFFFFF?text=Care+Kit+1', // Care kit option 1
        'https://via.placeholder.com/800x800/2980b9/FFFFFF?text=Care+Kit+2', // Care kit option 2
        'https://via.placeholder.com/800x800/5dade2/FFFFFF?text=Care+Kit+3', // Care kit option 3
        'https://via.placeholder.com/800x800/85c1e9/FFFFFF?text=Care+Kit+4', // Care kit option 4
    ],

    'ceramic-coating': [
        'https://via.placeholder.com/800x800/e74c3c/FFFFFF?text=Ceramic+Coating+1', // Ceramic coating option 1
        'https://via.placeholder.com/800x800/c0392b/FFFFFF?text=Ceramic+Coating+2', // Ceramic coating option 2
        'https://via.placeholder.com/800x800/ec7063/FFFFFF?text=Ceramic+Coating+3', // Ceramic coating option 3
        'https://via.placeholder.com/800x800/f1948a/FFFFFF?text=Ceramic+Coating+4', // Ceramic coating option 4
    ],

    'microfiber-towels': [
        'https://via.placeholder.com/800x800/f39c12/FFFFFF?text=Microfiber+Towels+1', // Microfiber towels option 1
        'https://via.placeholder.com/800x800/e67e22/FFFFFF?text=Microfiber+Towels+2', // Microfiber towels option 2
        'https://via.placeholder.com/800x800/f7dc6f/FFFFFF?text=Microfiber+Towels+3', // Microfiber towels option 3
        'https://via.placeholder.com/800x800/f8c471/FFFFFF?text=Microfiber+Towels+4', // Microfiber towels option 4
    ],

    'wax-collection': [
        'https://via.placeholder.com/800x800/9b59b6/FFFFFF?text=Wax+Collection+1', // Wax collection option 1
        'https://via.placeholder.com/800x800/8e44ad/FFFFFF?text=Wax+Collection+2', // Wax collection option 2
        'https://via.placeholder.com/800x800/bb8fce/FFFFFF?text=Wax+Collection+3', // Wax collection option 3
        'https://via.placeholder.com/800x800/d2b4de/FFFFFF?text=Wax+Collection+4', // Wax collection option 4
    ],

    'interior-cleaner': [
        'https://via.placeholder.com/800x800/1abc9c/FFFFFF?text=Interior+Cleaner+1', // Interior cleaner option 1
        'https://via.placeholder.com/800x800/16a085/FFFFFF?text=Interior+Cleaner+2', // Interior cleaner option 2
        'https://via.placeholder.com/800x800/5dade2/FFFFFF?text=Interior+Cleaner+3', // Interior cleaner option 3
        'https://via.placeholder.com/800x800/85c1e9/FFFFFF?text=Interior+Cleaner+4', // Interior cleaner option 4
    ],

    'leather-conditioner': [
        'https://via.placeholder.com/800x800/8b4513/FFFFFF?text=Leather+Conditioner+1', // Leather conditioner option 1
        'https://via.placeholder.com/800x800/a0522d/FFFFFF?text=Leather+Conditioner+2', // Leather conditioner option 2
        'https://via.placeholder.com/800x800/cd853f/FFFFFF?text=Leather+Conditioner+3', // Leather conditioner option 3
        'https://via.placeholder.com/800x800/deb887/FFFFFF?text=Leather+Conditioner+4', // Leather conditioner option 4
    ],

    'glass-cleaner': [
        'https://via.placeholder.com/800x800/87ceeb/FFFFFF?text=Glass+Cleaner+1', // Glass cleaner option 1
        'https://via.placeholder.com/800x800/4682b4/FFFFFF?text=Glass+Cleaner+2', // Glass cleaner option 2
        'https://via.placeholder.com/800x800/5dade2/FFFFFF?text=Glass+Cleaner+3', // Glass cleaner option 3
        'https://via.placeholder.com/800x800/85c1e9/FFFFFF?text=Glass+Cleaner+4', // Glass cleaner option 4
    ],

    // ACCESSORIES
    'sticker-pack': [
        'https://via.placeholder.com/800x800/ff6b6b/FFFFFF?text=Sticker+Pack+1', // Sticker pack option 1
        'https://via.placeholder.com/800x800/ee5a52/FFFFFF?text=Sticker+Pack+2', // Sticker pack option 2
        'https://via.placeholder.com/800x800/ff8a80/FFFFFF?text=Sticker+Pack+3', // Sticker pack option 3
        'https://via.placeholder.com/800x800/ffab91/FFFFFF?text=Sticker+Pack+4', // Sticker pack option 4
    ],

    'air-freshener': [
        'https://via.placeholder.com/800x800/ffd93d/FFFFFF?text=Air+Freshener+1', // Air freshener option 1
        'https://via.placeholder.com/800x800/ffc107/FFFFFF?text=Air+Freshener+2', // Air freshener option 2
        'https://via.placeholder.com/800x800/fff176/FFFFFF?text=Air+Freshener+3', // Air freshener option 3
        'https://via.placeholder.com/800x800/fff59d/FFFFFF?text=Air+Freshener+4', // Air freshener option 4
    ],

    'keychain': [
        'https://via.placeholder.com/800x800/ffa726/FFFFFF?text=Keychain+1', // Keychain option 1
        'https://via.placeholder.com/800x800/ff9800/FFFFFF?text=Keychain+2', // Keychain option 2
        'https://via.placeholder.com/800x800/ffb74d/FFFFFF?text=Keychain+3', // Keychain option 3
        'https://via.placeholder.com/800x800/ffcc02/FFFFFF?text=Keychain+4', // Keychain option 4
    ],

    'plate-frame': [
        'https://via.placeholder.com/800x800/607d8b/FFFFFF?text=Plate+Frame+1', // Plate frame option 1
        'https://via.placeholder.com/800x800/455a64/FFFFFF?text=Plate+Frame+2', // Plate frame option 2
        'https://via.placeholder.com/800x800/90a4ae/FFFFFF?text=Plate+Frame+3', // Plate frame option 3
        'https://via.placeholder.com/800x800/b0bec5/FFFFFF?text=Plate+Frame+4', // Plate frame option 4
    ],

    'phone-mount': [
        'https://via.placeholder.com/800x800/795548/FFFFFF?text=Phone+Mount+1', // Phone mount option 1
        'https://via.placeholder.com/800x800/5d4037/FFFFFF?text=Phone+Mount+2', // Phone mount option 2
        'https://via.placeholder.com/800x800/a1887f/FFFFFF?text=Phone+Mount+3', // Phone mount option 3
        'https://via.placeholder.com/800x800/bcaaa4/FFFFFF?text=Phone+Mount+4', // Phone mount option 4
    ],

    // TOOLS
    'foam-cannon': [
        'https://via.placeholder.com/800x800/3f51b5/FFFFFF?text=Foam+Cannon+1', // Foam cannon option 1
        'https://via.placeholder.com/800x800/303f9f/FFFFFF?text=Foam+Cannon+2', // Foam cannon option 2
        'https://via.placeholder.com/800x800/7986cb/FFFFFF?text=Foam+Cannon+3', // Foam cannon option 3
        'https://via.placeholder.com/800x800/9fa8da/FFFFFF?text=Foam+Cannon+4', // Foam cannon option 4
    ],

    'brush-set': [
        'https://via.placeholder.com/800x800/4caf50/FFFFFF?text=Brush+Set+1', // Brush set option 1
        'https://via.placeholder.com/800x800/388e3c/FFFFFF?text=Brush+Set+2', // Brush set option 2
        'https://via.placeholder.com/800x800/81c784/FFFFFF?text=Brush+Set+3', // Brush set option 3
        'https://via.placeholder.com/800x800/a5d6a7/FFFFFF?text=Brush+Set+4', // Brush set option 4
    ],

    'polisher': [
        'https://via.placeholder.com/800x800/ff5722/FFFFFF?text=Polisher+1', // Polisher option 1
        'https://via.placeholder.com/800x800/e64a19/FFFFFF?text=Polisher+2', // Polisher option 2
        'https://via.placeholder.com/800x800/ff8a65/FFFFFF?text=Polisher+3', // Polisher option 3
        'https://via.placeholder.com/800x800/ffab91/FFFFFF?text=Polisher+4', // Polisher option 4
    ],
};

function downloadImage(url, filepath) {
    return new Promise((resolve, reject) => {
        const file = fs.createWriteStream(filepath);
        https.get(url, (response) => {
            if (response.statusCode === 301 || response.statusCode === 302) {
                https.get(response.headers.location, (redirectResponse) => {
                    redirectResponse.pipe(file);
                    file.on('finish', () => {
                        file.close();
                        resolve();
                    });
                }).on('error', reject);
            } else {
                response.pipe(file);
                file.on('finish', () => {
                    file.close();
                    resolve();
                });
            }
        }).on('error', (err) => {
            fs.unlink(filepath, () => { });
            reject(err);
        });
    });
}

async function downloadAllOptions() {
    console.log('🎨 Downloading PLACEHOLDER images with different colors...\n');
    console.log('Each option has a unique color and text for easy identification!\n');

    const optionsDir = path.join(__dirname, '..', 'public', 'images', 'options');

    // Create options directory
    if (!fs.existsSync(optionsDir)) {
        fs.mkdirSync(optionsDir, { recursive: true });
    }

    let totalDownloaded = 0;

    for (const [productName, urls] of Object.entries(imageOptions)) {
        console.log(`\n📦 ${productName}:`);

        // Create product subfolder
        const productDir = path.join(optionsDir, productName);
        if (!fs.existsSync(productDir)) {
            fs.mkdirSync(productDir, { recursive: true });
        }

        for (let i = 0; i < urls.length; i++) {
            const filepath = path.join(productDir, `option-${i + 1}.jpg`);
            try {
                await downloadImage(urls[i], filepath);
                console.log(`  ✓ Option ${i + 1} - Unique color`);
                totalDownloaded++;
                await new Promise(resolve => setTimeout(resolve, 100));
            } catch (error) {
                console.log(`  ✗ Option ${i + 1} failed`);
            }
        }
    }

    console.log(`\n\n✅ Downloaded ${totalDownloaded} PLACEHOLDER image options!`);
    console.log(`\n📁 Location: public/images/options/`);
    console.log(`\n📝 Instructions:`);
    console.log(`   1. Browse to: public/images/options/`);
    console.log(`   2. Each product has its own folder with 4 COLORED options`);
    console.log(`   3. Each option has different colors and text labels`);
    console.log(`   4. Pick your favorite option for each product`);
    console.log(`   5. Let me know which numbers you want (e.g., "logo-tee: option-2")`);
    console.log(`   6. I'll replace these with real product images based on your choices\n`);
}

downloadAllOptions().catch(console.error);
